package gov.va.med.mhv.bluebutton.bbmi;

import javax.annotation.Resource;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import gov.va.med.mhv.bluebutton.StudyJobBusinessService;
import gov.va.med.mhv.bluebutton.transfer.BbmiEventMessage;
import gov.va.med.mhv.common.api.cache.CacheHandler;
import gov.va.med.mhv.common.api.exception.MHVException;

public class BbmiMdbListener implements MessageListener {

	private static final String API_TOKEN = "Token";
	
	@Resource
	StudyJobBusinessService studyJobBusinessService;

	@Resource
	gov.va.med.mhv.bluebutton.BBMIMdbService bbmiMdbService;

	private static final Log LOG = LogFactory.getLog(BbmiMdbListener.class);

	public void onMessage(Message message) {

		String apiToken = null;

		if (!(message instanceof ObjectMessage)) {
			throw new IllegalStateException("The PaymentListener queue expects an object message");
		}

		try {
			ObjectMessage objectMessage = (ObjectMessage) message;
			apiToken = message.getStringProperty(API_TOKEN);

			if (objectMessage.getObject() instanceof BbmiEventMessage) {
				BbmiEventMessage bbmiEventMsg = (BbmiEventMessage) objectMessage.getObject();
				
//				if (LOG.isInfoEnabled()) {
//					LOG.info("PAT INFO at Listener:" + 
//						" PatientId:" + bbmiEventMsg.getPatientId() +
//						" StudyId:" + bbmiEventMsg.getStudyId()
//						);
//				}	

				// if an API Token was presented in the request, 
				// add it to the CacheHandler thread local variable
				// so that it can be used to authorize downstream 
				// service requests.
				if (apiToken != null && apiToken.length() > 0) {
					if(LOG.isDebugEnabled()) {
						LOG.debug(String.format("%s:%s", API_TOKEN, apiToken));
					}
					CacheHandler.getInstance().setToken(apiToken);
				}

				// TODO: ADD Cvix calls to fetch the study
				// studyJobBusinessService.createZipFile(bbmiEventMsg);
				bbmiMdbService.doCvixServiceJob(bbmiEventMsg);
			}

			// System.out.println(((TextMessage) message).getText());
			// System.out.println("About to proces the Study....");

		} catch (JMSException ex) {
			throw new RuntimeException(ex);
		} catch (MHVException e) {
			LOG.error("exception occured" + e);
		} finally {
			// Clear out the cache handler thread local instance
			// so that there is no leftover data in subsequest 
			// requests.
			CacheHandler.resetInstance();
		}
	}
}
